
/*{
    "DESCRIPTION": "Mixer",
    "CREDIT": "",
    "ISFVSN": "2",
    "CATEGORIES": [
        "Composition"
    ],
    "INPUTS": [
        {
            "NAME": "inputImage",
            "TYPE": "image"
        },
        {
            "NAME": "topImage",
            "TYPE": "image"
        },
        {
            "NAME": "dryWet",
            "TYPE": "float",
            "DEFAULT": 1.0,
            "MIN": 0.0,
            "MAX": 1.0
        }
    ]
    
}*/

void main() {
    vec4 bottom = IMG_NORM_PIXEL(inputImage, isf_FragNormCoord);
    vec4 top = IMG_NORM_PIXEL(topImage, isf_FragNormCoord);
    float luma = dot(top.rgb, vec3(0.299, 0.587, 0.114));

    gl_FragColor = luma > 0.3 ? mix(bottom, top, dryWet) : mix(bottom, top, (luma / 0.3) * dryWet);
}
